# import des different composants necessaires
from vtk import *

# ------------------------------------------------
# creation de structure de donnee
# ------------------------------------------------
   
nbpoints = 8

# Definition des noeuds
pointCoord   = range(nbpoints)
pointCoord[0]=(0.0, 0.0, 0.0)
pointCoord[1]=(0.3, 0.1, 1.0)
pointCoord[2]=(0.7, 0.1, -0.2)
pointCoord[3]=(0.5, 1.2, 1.1)
pointCoord[4]=(0.9, 2.0, -0.3)
pointCoord[5]=(1.5, 2.5, 1.4)
pointCoord[6]=(0.2, 3.4, -1.2)
pointCoord[7]=(2, 4, -1.2)

# Definition des valeures correspondantes
ptData    = range(nbpoints)
ptData[0] = 1.0
ptData[1] = 1.2
ptData[2] = 1.6
ptData[3] = 2.0
ptData[4] = 2.5
ptData[5] = 3.4
ptData[6] = 5.7
ptData[7] = 7.0


# Constantes definissant le type de cellule
# NB: Deja definies dans VTK, redefinies ici que pour 
# la lisibite de l'exemple
VTK_TETRA = 10
VTK_TRIANGLE = 5
VTK_LINE = 3
VTK_VERTEX = 1

dataset =  vtkUnstructuredGrid()
points = vtkPoints()

for i in range(nbpoints):
	points.InsertNextPoint(pointCoord[i])


data = vtkFloatArray()
data.SetName("My data name")
data.SetNumberOfTuples(1)
data.SetNumberOfValues(nbpoints)


# 1er tetrahedre
idList = vtkIdList()
idList.InsertNextId(0)
idList.InsertNextId(1)
idList.InsertNextId(2)
idList.InsertNextId(3)
dataset.InsertNextCell( VTK_TETRA, idList) #VTK_TETRA = 10

# 2eme tetrahedre
idList = vtkIdList()
idList.InsertNextId(0)
idList.InsertNextId(2)
idList.InsertNextId(3)
idList.InsertNextId(4)
dataset.InsertNextCell( VTK_TETRA, idList) #VTK_TETRA = 10

# le triangle
idList = vtkIdList()
idList.InsertNextId(3)
idList.InsertNextId(4)
idList.InsertNextId(5)
dataset.InsertNextCell( VTK_TRIANGLE, idList) #VTK_TRIANGLE = 5

# l'arrete
idList = vtkIdList()
idList.InsertNextId(5)
idList.InsertNextId(6)
dataset.InsertNextCell( VTK_LINE, idList) #VTK_LINE = 3

# le dernier noeud en tant que simple vertex
idList = vtkIdList()
idList.InsertNextId(7)
dataset.InsertNextCell( VTK_VERTEX, idList) #VTK_VERTEX = 1


# attribution des valeurs aux noeuds
for i in range(nbpoints):
        data.InsertTuple1(i, ptData[i])
	        
                
dataset.SetPoints(points)		
dataset.GetPointData().SetScalars(data)
# ------------------------------------------------
# fin de la creation de structure de donnee
# ------------------------------------------------
